/*
 * Decompiled with CFR 0.152.
 */
package jade.core.messaging;

import jade.core.AID;
import jade.core.Profile;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessageManager;
import jade.core.messaging.MessageStorage;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.LinkedList;
import jade.util.leap.List;
import jade.util.leap.Map;
import java.io.IOException;

class PersistentDeliveryManager {
    private static final long DEFAULT_SENDFAILUREPERIOD = 60000L;
    private static final String DEFAULT_STORAGE = "jade.core.messaging.PersistentDeliveryManager$DummyStorage";
    private static PersistentDeliveryManager theInstance;
    private MessageManager myMessageManager;
    private MessageManager.Channel deliveryChannel;
    private long sendFailurePeriod;
    private long users;
    private Map pendingMessages = new HashMap();
    private ExpirationChecker failureSender;
    private MessageStorage storage;

    public static synchronized PersistentDeliveryManager instance(Profile p, MessageManager.Channel ch) {
        if (theInstance == null) {
            theInstance = new PersistentDeliveryManager();
            theInstance.initialize(p, ch);
        }
        return theInstance;
    }

    public void initialize(Profile p, MessageManager.Channel ch) {
        block5: {
            this.users = 0L;
            this.myMessageManager = MessageManager.instance(p);
            this.deliveryChannel = ch;
            try {
                String storageClass = p.getParameter("persistent-delivery-storagemethod", DEFAULT_STORAGE);
                this.storage = (MessageStorage)Class.forName(storageClass).newInstance();
                this.storage.init(p);
                this.storage.loadAll(new MessageStorage.LoadListener(){

                    public void loadStarted(String storeName) {
                        System.out.println("--> Load BEGIN <--");
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void itemLoaded(String storeName, GenericMessage msg, AID receiver) {
                        Map map = PersistentDeliveryManager.this.pendingMessages;
                        synchronized (map) {
                            List msgs = (List)PersistentDeliveryManager.this.pendingMessages.get(receiver);
                            if (msgs == null) {
                                msgs = new LinkedList();
                                PersistentDeliveryManager.this.pendingMessages.put(receiver, msgs);
                            }
                            DeliveryItem item = new DeliveryItem(msg, receiver, PersistentDeliveryManager.this.deliveryChannel, storeName);
                            msgs.add(item);
                        }
                        System.out.println("Message for <" + receiver.getLocalName() + ">");
                    }

                    public void loadEnded(String storeName) {
                        System.out.println("--> Load END <--");
                    }
                });
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sendFailurePeriod = 60000L;
            String s = p.getParameter("persistent-delivery-sendfailureperiod", null);
            if (s == null) break block5;
            try {
                this.sendFailurePeriod = Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeMessage(String storeName, GenericMessage msg, AID receiver) throws IOException {
        Map map = this.pendingMessages;
        synchronized (map) {
            List msgs = (List)this.pendingMessages.get(receiver);
            if (msgs == null) {
                msgs = new LinkedList();
                this.pendingMessages.put(receiver, msgs);
            }
            String tmpName = this.storage.store(msg, receiver);
            msgs.add(new DeliveryItem(msg, receiver, this.deliveryChannel, tmpName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flushMessages(AID receiver) {
        int cnt = 0;
        List l = null;
        Map map = this.pendingMessages;
        synchronized (map) {
            l = (List)this.pendingMessages.remove(receiver);
        }
        if (l != null) {
            Iterator it = l.iterator();
            while (it.hasNext()) {
                DeliveryItem item = (DeliveryItem)it.next();
                this.retry(item);
                ++cnt;
            }
        }
        return cnt;
    }

    public synchronized void start() {
        if (this.users == 0L) {
            this.failureSender = new ExpirationChecker(this.sendFailurePeriod);
            this.failureSender.start();
        }
        ++this.users;
    }

    public synchronized void stop() {
        --this.users;
        if (this.users == 0L) {
            this.failureSender.stop();
        }
    }

    private PersistentDeliveryManager() {
    }

    private void retry(DeliveryItem item) {
        try {
            this.storage.delete(item.getStoreName(), item.getReceiver());
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.myMessageManager.deliver(item.getMessage(), item.getReceiver(), item.getChannel());
    }

    public static class DummyStorage
    implements MessageStorage {
        public void init(Profile p) {
        }

        public String store(GenericMessage msg, AID receiver) throws IOException {
            return null;
        }

        public void delete(String storeName, AID receiver) throws IOException {
        }

        public void loadAll(MessageStorage.LoadListener il) throws IOException {
        }
    }

    private class ExpirationChecker
    implements Runnable {
        private boolean active = false;
        private long period;
        private Thread myThread;

        public ExpirationChecker(long t) {
            this.period = t;
            this.myThread = new Thread((Runnable)this, "Persistent Delivery Service -- Expiration Checker Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.active) {
                try {
                    Thread.sleep(this.period);
                    Map map = PersistentDeliveryManager.this.pendingMessages;
                    synchronized (map) {
                        Object[] keys = PersistentDeliveryManager.this.pendingMessages.keySet().toArray();
                        int i = 0;
                        while (i < keys.length) {
                            PersistentDeliveryManager.this.flushMessages((AID)keys[i]);
                            ++i;
                        }
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }

        public void start() {
            this.active = true;
            this.myThread.start();
        }

        public void stop() {
            this.active = false;
            this.myThread.interrupt();
        }
    }

    private static class DeliveryItem {
        private GenericMessage toDeliver;
        private AID receiver;
        private MessageManager.Channel channel;
        private String storeName;

        public DeliveryItem(GenericMessage msg, AID id, MessageManager.Channel ch, String sid) {
            this.toDeliver = msg;
            this.receiver = id;
            this.channel = ch;
            this.storeName = sid;
        }

        public GenericMessage getMessage() {
            return this.toDeliver;
        }

        public AID getReceiver() {
            return this.receiver;
        }

        public MessageManager.Channel getChannel() {
            return this.channel;
        }

        public String getStoreName() {
            return this.storeName;
        }
    }
}

